<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */
?>
    <div class="px-0 mb-5 border-0">
        <h4 class="mb-5 separatore-inferiore"><?= $gestoreTraduzioni->traduci("Lascia un commento",$lingua) ?></h4>
        <form role="form" action="creaCommento.php" method="get">
            <input type="text" class="d-none" id="idContenuto" <?php echo"value={$contenuto["id"]}"; ?> >
            <div class="form-label-group">
                <input type="text" class="form-control" id="nome" name="Nome" value="" placeholder="<?= $gestoreTraduzioni->traduci("Nome",$lingua) ?>"  >
                <label for="nome" ><?= $gestoreTraduzioni->traduci("Nome",$lingua) ?></label>
            </div>
            <div class="form-label-group">
                <input type="text" class="form-control" id="email" name="Email" value="" placeholder="<?= $gestoreTraduzioni->traduci("Email",$lingua) ?>"  >
                <label for="email" ><?= $gestoreTraduzioni->traduci("Email",$lingua) ?></label>
            </div>
            <div class="form-label-group">
                <textarea type="text"  rows="10"  class="form-control" id="testo" name="testo"  placeholder="<?= $gestoreTraduzioni->traduci("Testo del commento",$lingua) ?>" form-label-group ></textarea>
                <label for="testo"><?= $gestoreTraduzioni->traduci("Testo del commento",$lingua) ?></label>
            </div>
            
            <div class="custom-control custom-checkbox my-3 mr-sm-2">
                <input type="checkbox" id="accettazioneTerminiCondizioni" value="si" class="custom-control-input"> 
                <label class="custom-control-label" for="accettazioneTerminiCondizioni">
                    <?= $gestoreTraduzioni->traduci("Accetto le",$lingua) ?> <a id="pulsanteAggiungiCommento" href="index.php?alias=informativa-sulla-privacy" target="_blank"><span id="spanPulsanteAggiungiCommento"></span><?= $gestoreTraduzioni->traduci("Condizioni sulla privacy",$lingua) ?></a>
                </label>
            </div>
            <button type="button" class="btn btn-lg btn-primary btn-block" onclick="aggiungiCommento('<?= $impostazioni["bloccaLinkCommenti"]; ?>',0);"><?= $gestoreTraduzioni->traduci("Invia",$lingua) ?></button>
        </form>
    </div>
    <!-- /form commento -->
            
    <!-- div dei commenti, viene mostrato solo se i commenti sono abilitati -->
    <?php 
        if($contenuto["abilitaCommenti"]=="si") {
            echo"<div id=\"commenti\" class=\"lista-commenti py-5\">";
            $queryCommenti = "SELECT * FROM geecB_commenti WHERE idContenuto={$contenuto["id"]} AND inRispostaA=0";
            $risCommenti = $geecomDb->eseguiQueryLettura($queryCommenti);
            while($commento = $risCommenti->fetch_assoc()) {
                $data = date("d/m/Y",strtotime($commento["dataCreazione"]));
                echo"<div class=\"media my-3\">
                        <div class=\"media-body\">
                            <h5 class=\"mt-0\">{$commento["nomeAutore"]}</h5>
                            <hr class=\"my-1\">
                            {$commento["testo"]}
                            <small class=\"d-block mt-2 text-muted\"><i class=\"fas fa-calendar-alt\"></i> $data</small>";
                            
                            // stampa eventuali articoli in risposta
                            $queryCommenti = "SELECT * FROM geecB_commenti WHERE idContenuto={$contenuto["id"]} AND inRispostaA={$commento["id"]}";
                            $risCommentiInRisposta = $geecomDb->eseguiQueryLettura($queryCommenti);
                            while($commentoInRisposta = $risCommentiInRisposta->fetch_assoc()) {
                                $dataRisposta = date("d/m/Y",strtotime($commentoInRisposta["dataCreazione"]));
                                echo"<div class=\"media my-3 ml-5\">
                                    <div class=\"media-body\">
                                        <h5 class=\"mt-0\">{$commentoInRisposta["nomeAutore"]}</h5>
                                        <hr class=\"my-1\">
                                        {$commentoInRisposta["testo"]}
                                        <small class=\"d-block mt-2 text-muted\"><i class=\"fas fa-calendar-alt\"></i> $data</small>
                                    </div>
                                </div>";
                            }
                            
                            // infine stampa i pulsanti per rispondere e segnalareil commento e poi il form di risposta
                            echo"<div class=\"clearfix\"></div>
                            <div class=\"float-right\">
                                <button type=\"button\" class=\"btn btn-primary btn-sm invia\" onclick=\"generaFormRispondi('formRisposta{$commento["id"]}')\">".$gestoreTraduzioni->traduci("Rispondi",$lingua)."</button>
                                <button type=\"button\" class=\"btn btn-sm btn-outline-warning\" onclick=\"segnalaCommento({$commento["id"]})\">".$gestoreTraduzioni->traduci("Segnala",$lingua)."</button>
                            </div>
                            <div id=\"formRisposta{$commento["id"]}\" class=\"d-none\">
                                <h6 class=\"my-5 separatore-inferiore\">".$gestoreTraduzioni->traduci("Rispondi",$lingua)."</h6>
                                <form role=\"form\" action=\"creaCommento.php\" method=\"get\">
                                    <div class=\"form-label-group\">
                                        <input type=\"text\" class=\"form-control\" id=\"nome{$commento["id"]}\" name=\"Nome\" value=\"\" placeholder=\"Nome\">
                                        <label for=\"nome{$commento["id"]}\" >Nome</label>
                                    </div>
                                    <div class=\"form-label-group\">
                                        <input type=\"text\" class=\"form-control\" id=\"email{$commento["id"]}\" name=\"Email\" value=\"\" placeholder=\"Email\">
                                        <label for=\"email{$commento["id"]}\" >Email</label>
                                    </div>
                                    <div class=\"form-label-group\">
                                        <textarea type=\"text\"  rows=\"10\"  class=\"form-control\" id=\"testo{$commento["id"]}\" name=\"testo\"  placeholder=\"Testo del messaggio\" form-label-group ></textarea>
                                        <label for=\"testo{$commento["id"]}\">Testo del commento</label>
                                    </div>
                                    <div class=\"custom-control custom-checkbox my-3 mr-sm-2\">
                                        <input type=\"checkbox\" id=\"accettazioneTerminiCondizioni{$commento["id"]}\" value=\"si\" class=\"custom-control-input\"> 
                                        <label class=\"custom-control-label\" for=\"accettazioneTerminiCondizioni{$commento["id"]}\">
                                            Accetto le <a href=\"index.php?alias=informativa-sulla-privacy\" target=\"_blank\">Condizioni sulla privacy</a>
                                        </label>
                                    </div>
                                    <button type=\"button\" class=\"btn btn-lg btn-primary btn-block\" onclick=\"aggiungiCommento('{$impostazioni["bloccaLinkCommenti"]}',{$commento["id"]});\">Invia</button>
                                </form>    
                            </div>
                    </div>
                </div>";
            }
            echo"</div>";
        }